 ; Ŀ
 ;   Inc - add 1 to the first number in a selected text string.            
 ;   Linc - add 1 to the last number in a selected text string.            
 ;   Ink, add 1 to all numbers in all selected text/mtext/blocks.          
 ;   Dec, subtract 1 from the first number in a selected text string.      
 ;   Ldec, subtract 1 from the last number in a selected text string.      
 ;   Dek, subtract 1 from all numbers in all selected text/mtext/blocks.   
 ;   Copyright 2005, 2010 by Rocket Software Ltd.                          
 ;   There are creatures which make light, electricity, and acid, but      
 ;   no explosive ones.                                                    
 ; 

 ; Ŀ
 ;   Subroutine CI - grdraw circle maker.                                  
 ; 
 (DEFUN CI (pa radd colo / reps pa pa1 pa2 angg)
  (setq reps 32)
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (setq pa1 (polar pa angg radd))
  (repeat reps
          (setq angg (+ angg incr))
          (setq pa2 (polar pa angg radd))
          (grdraw pa1 pa2 colo)
          (setq pa1 pa2))
 (princ))
 ; Ŀ
 ;   Ci end.                                                               
 ; 

 ; Ŀ
 ;   Decal - increment/decrement the last number substr in a text string.  
 ;   Arguments: String, a text string.                                     
 ;              Indec, "+" = increment, "-" = decrement.                   
 ;   Calls Monster.                                                        
 ;   Returns either the modified string or nil if it wasn't changed.       
 ; 
 (DEFUN DECAL (string indec / strlst numa nufou gnustr numap)
  (setq gnustr "")
  (setq strlst (reverse (monster string)))
  (while (setq numa (car strlst))
         (setq strlst (cdr strlst))
         (setq numap (read numa))
         (if (and (member (type numap) '(REAL INT))
                  (null nufou))
             (progn
                  (if (= indec "+")
                      (setq numap (1+ numap))
                      (setq numap (1- numap)))
                  (setq nufou t)
                  (cond ((= (type numap) 'REAL)
                         (setq numap (rtos numap)))
                        ((= (type numap) 'INT)
                         (setq numap (itoa numap))))
                  (setq gnustr (strcat numap gnustr)))
             (setq gnustr (strcat numa gnustr))))
 (if nufou gnustr string))
 ; Ŀ
 ;   Decal end.                                                            
 ; 

 ; Ŀ
 ;   Dekk - subtract 1 from all number substrings in a text string.        
 ;   Arguments: String, a text string.                                     
 ;   Calls Monster.                                                        
 ;   Returns a list: the modified string and the number of changes.        
 ; 
 (DEFUN DEKK (string / tao strlst numa gnustr numap)
  (setq tao 0)                          ; substrings incremented counter
  (setq gnustr "")
  (setq strlst (monster string))
  (while (setq numa (car strlst))
         (setq strlst (cdr strlst))
         (setq numap (read numa))
         (if (member (type numap) '(REAL INT))
             (progn
                  (setq numap (1- numap))
                  (setq tao (1+ tao))
                  (cond ((= (type numap) 'REAL)
                         (setq numap (rtos numap)))
                        ((= (type numap) 'INT)
                         (setq numap (itoa numap))))
                  (setq gnustr (strcat gnustr numap)))
             (setq gnustr (strcat gnustr numa))))
 (list gnustr tao))
 ; Ŀ
 ;   Dekk end.                                                             
 ; 

 ; Ŀ
 ;   Incab - increment or decrement part of the string in an entity.       
 ;   Arguments: Dira, increment or decrement, "+" or "-".                  
 ;              Begend, "p" = first nuber substring, "s" = last.           
 ;              Poro, the prompt string.                                   
 ;   Calls Incdec or Decal.                                                
 ;   Returns nothing.                                                      
 ; 
 (DEFUN INCAB (dira begend poro / snapp *error* nent enam stra renam entt typ
                                                                  outer cc nn)
  (setvar "cmdecho" 0)
  (command "undo" "mark")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
 (defun *error* (shk /)
  (setvar "snapmode" snapp)
  (if renam (redraw renam 4))
  (if shk (write-line shk))
 (princ))
 ; Ŀ
 ;   Get an entity.                                                        
 ; 
  (setq enam (car (setq nent (nentsel poro))))
  (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
  (if (or (= "TEXT" typ) (= "MTEXT" typ) (= "ATTDEF" typ) (= "ATTRIB" typ))
      (progn
           (if (not (setq sub (assoc 3 entt)))
               (setq sub (assoc 1 entt)))
           (princ (setq stra (cdr sub)))
           (redraw (setq renam (cdr (assoc -1 entt))) 3)
           (setq outer (car (reverse (car (reverse nent)))))
 ; Ŀ
 ;   Call the start/end increment/decrement routine.                       
 ; 
           (if (= (strcase begend t) "p")
               (setq strb (incdec stra dira))
               (setq strb (decal stra dira)))
 ; Ŀ
 ;   If a change was made.                                                 
 ; 
           (if strb
               (progn
                    (redraw renam 4)
                    (setq cara (car sub))
                    (entmod (subst (cons cara strb) (assoc cara entt) entt))
                    (entupd enam)
                    (if (= (type outer) 'ENAME) (entupd outer)))
               (redraw renam 4))))
  (*error* nil)
 (princ))
 ; Ŀ
 ;   Incab end.                                                            
 ; 

 ; Ŀ
 ;   Incdec - add or subtract 1 to or from the first number substring in   
 ;   a text string.                                                        
 ;   Arguments: String, a text string.                                     
 ;              Dira, add or subtract: "+" or "-".                         
 ;   Calls Monster.                                                        
 ;   Returns either the modified string or nil if it wasn't changed.       
 ; 
 (DEFUN INCDEC (string dira / strlst numa nufou gnustr numap)
  (setq gnustr "")
  (setq strlst (monster string))
  (while (setq numa (car strlst))
         (setq strlst (cdr strlst))
         (setq numap (read numa))
         (if (and (member (type numap) '(REAL INT))
                  (null nufou))
             (progn
                  (if (= dira "+")
                      (setq numap (1+ numap))
                      (setq numap (1- numap)))
                  (setq nufou t)
                  (cond ((= (type numap) 'REAL)
                         (setq numap (rtos numap)))
                        ((= (type numap) 'INT)
                         (setq numap (itoa numap))))
                  (setq gnustr (strcat gnustr numap)))
             (setq gnustr (strcat gnustr numa))))
 (if nufou gnustr string))
 ; Ŀ
 ;   Incdec end.                                                           
 ; 

 ; Ŀ
 ;   Ink - add 1 to all number substrings in a text string.                
 ;   Arguments: String, a text string.                                     
 ;   Calls Monster.                                                        
 ;   Returns a list: the modified string and the number of changes.        
 ; 
 (DEFUN INK (string / tao strlst numa gnustr numap)
  (setq tao 0)                          ; substrings incremented counter
  (setq gnustr "")
  (setq strlst (monster string))
  (while (setq numa (car strlst))
         (setq strlst (cdr strlst))
         (setq numap (read numa))
         (if (member (type numap) '(REAL INT))
             (progn
                  (setq numap (1+ numap))
                  (setq tao (1+ tao))
                  (cond ((= (type numap) 'REAL)
                         (setq numap (rtos numap)))
                        ((= (type numap) 'INT)
                         (setq numap (itoa numap))))
                  (setq gnustr (strcat gnustr numap)))
             (setq gnustr (strcat gnustr numa))))
 (list gnustr tao))
 ; Ŀ
 ;   Ink end.                                                              
 ; 

 ; Ŀ
 ;   Inkal - increment or decrement all strings in an ss.                  
 ;   Arguments: Suba, the subroutine to call.                              
 ;              Subs, the partial prompt string.                           
 ;   Also calls Nooma, but returns nothing.                                
 ; 
 (DEFUN INKAL (suba subs / *error* rad colo angg anginc sparam ss num tta enam
                                                                         curno)
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (if (/= shk "Function cancelled") (write-line shk))
  (princ))
 ; Ŀ
 ;   Initialize settings.                                                  
 ; 
  (setq rad (/ (getvar "viewsize") 80))
  (setq colo 7)
  (setq angg 1.5)
  (setq anginc 0.72)
 ; Ŀ
 ;   Get an ss of text and blocks with attributes.                         
 ; 
  (setq sparam '((-4 . "<or") (0 . "text") (0 . "mtext")
                 (-4 . "<and") (0 . "insert") (66 . 1)
                 (-4 . "and>") (-4 . "or>")))
  (write-line (strcat "Select Text, Mtext, and Blocks to " subs ": "))
  (setq ss (ssget sparam))
 ; Ŀ
 ;   Increment each string.                                                
 ; 
  (setq num 0)
  (setq incnum 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq curno (nooma enam suba))
         (setq incnum (+ incnum curno))
         (setq num (1+ num)))
 ; Ŀ
 ;   Sum up and end.                                                       
 ; 
  (write-line (strcat "\n"
                      (itoa incnum) " number" (if (not (= incnum 1)) "s")
                      (strcase subs t) "ed in "
                      (itoa num) " mtext/text/attribute entit"
                      (if (= num 1) "y" "ies") "."))
 (princ))
 ; Ŀ
 ;   Inkal end.                                                            
 ; 

 ; Ŀ
 ;   Monster - separate a text string into numbers and letters.            
 ;   Copyright 1992 by Rocket Software Ltd.                                
 ;   This function returns a list of strings, alternating between          
 ;   numbers and letters.  The first string is always a character string   
 ;   - if the first character is a number then the first string will be    
 ;   empty ("").                                                           
 ;   A period (.) will be interpreted as being the same type as the        
 ;   preceding character.                                                  
 ; 
 (DEFUN MONSTER (string / chastr pre ascnum posi this asc last strlist)
  (setq chastr "")
  (setq pre "c")
  (setq ascnum (list 48 49 50 51 52 53 54 55 56 57))
  (setq posi 1)
  (while (/= "" (setq this (substr string posi 1)))
       (setq asc (ascii this))
       (cond ((member asc ascnum)         ; if char is a number
              (setq last "n"))
             ((= asc 46)                  ; if char is a .
              (if (= last "c")
                  (setq last "c")
                  (setq last "n")))
             (T                           ; otherwise it must be a letter
               (setq last "c")))
 ; Ŀ
 ;   If pre = last then strcat "this" onto chastr.                         
 ;   If not then append chastr onto strlist and set chastr to this.        
 ; 
       (if (equal pre last)
           (setq chastr (strcat chastr this))
           (progn
                (if strlist
                   (setq strlist (append strlist (list chastr)))
                   (setq strlist (list chastr)))
                (setq chastr this)))
       (setq pre last)
       (setq posi (1+ posi)))
  (if chastr (setq strlist (append strlist (list chastr))))
 strlist)
 ; Ŀ
 ;   Monster end.                                                          
 ; 

 ; Ŀ
 ;   Nooma - increment/decrement the numbers in a block or text string.    
 ;   Arguments: Enam, the entity name.                                     
 ;              Suba, the increment/decrement subroutine to call.          
 ;   Returns the number of substrings changed.                             
 ; 
 (DEFUN NOOMA (enam suba / esav typ entt stra incnum gnulis incx num)
  (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
 ; Ŀ
 ;   Text.                                                                 
 ; 
  (cond ((= typ "TEXT")
         (setq stra (suba (cdr (setq asoc1 (assoc 1 entt)))))
         (setq incnum (cadr stra))
         (setq stra (car stra))
         (entmod (subst (cons 1 stra) asoc1 entt))
         (if (not (zerop incnum))
             (screw (spit entt))))
 ; Ŀ
 ;   Mtext.                                                                
 ; 
        ((= typ "MTEXT")
         (setq incnum 0)
         (setq num 0)
         (while (setq sub (nth num entt))
                (setq num (1+ num))
                (if (member (car sub) '(1 3))
                    (progn
                         (setq stra (suba (cdr sub)))
                         (setq incx (cadr stra))
                         (if (> incx 0)
                             (progn
                                  (setq gnulis (append gnulis (list 
                                                (cons (car sub) (car stra)))))
                                  (setq incnum (+ incx incnum)))))
                    (setq gnulis (append gnulis (list sub)))))
         (entmod gnulis)
         (if (not (zerop incnum))
             (screw (spit entt))))
 ; Ŀ
 ;   Insert.                                                               
 ; 
        ((= typ "INSERT")
         (setq esav enam)
         (setq incnum 0)
         (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                               (setq enam (entnext enam)))))))
                (setq stra (suba (cdr (setq asoc1 (assoc 1 entt)))))
                (setq incx (cadr stra))
                (if (null (zerop incx))
                    (progn
                         (setq incnum (+ incx incnum))
                         (setq stra (car stra))
                         (entmod (subst (cons 1 stra) asoc1 entt))
                         (screw (spit entt)))))
         (if (not (zerop incnum))
             (entupd esav))))
 incnum)
 ; Ŀ
 ;   Nooma end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Radi - grdraw radial line set maker.                       
 ;   Does a complete circular set.                                         
 ;   Arguments: Pa, the base point.                                        
 ;              Rin, near end distance.                                    
 ;              Rout, far end distance.                                    
 ;              Reps, number of repetions in 360 degrees.                  
 ;              Stang, the start angle.                                    
 ;              Colo, the colour.                                          
 ;   Calls its mother, returns the empties.                                
 ; 
 (DEFUN RADI (pa rin rout reps stang colo / pa1 pa2)
  (setq incr (/ pi (/ reps 2)))
  (repeat reps
          (setq pa1 (polar pa stang rin))
          (setq pa2 (polar pa stang rout))
          (grdraw pa1 pa2 colo)
          (setq stang (+ stang incr)))
 (princ))
 ; Ŀ
 ;   Radi end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Screw - grdraw a screw head.                               
 ;   Arguments: Pa, the base point.                                        
 ;   Calls Ci, returns nothing.                                            
 ;   Global variables: Angg, the slot angle.                               
 ;                     Anginc, the angle increment.                        
 ;                     Rad, the head radius.                               
 ;                     Colo, the grdraw colour.                            
 ;   Note that the global variables are local to the calling function      
 ;   - they can't be declared local to Screw.                              
 ; 
 (DEFUN SCREW (pa / widang p1a p1b p2a p2b)
  (setq widang 0.15)
  (setq p1a (polar pa (+ angg widang) rad))
  (setq p1b (polar pa (+ angg widang) (- rad)))
  (setq p2a (polar pa (- angg widang) rad))
  (setq p2b (polar pa (- angg widang) (- rad)))
  (grdraw p1a p2b colo)
  (grdraw p2a p1b colo)
  (ci pa rad colo)
  (setq angg (+ angg anginc))
 (princ))
 ; Ŀ
 ;   Screw end.                                                            
 ; 

 ; Ŀ
 ;   Spit - returns the insertion point of the text entity whose data was  
 ;   passed as its sole argument.  Note that this is not necessarily the   
 ;   same as the 10 association code.                                      
 ; 
 (DEFUN SPIT (entt / xjust yjust)
  (setq xjust (cdr (assoc 72 entt)))
  (setq yjust (cdr (assoc 73 entt)))
  (if (or (/= xjust 0) (/= yjust 0))
      (cdr (assoc 11 entt))
      (cdr (assoc 10 entt))))
 ; Ŀ
 ;   Spit end.                                                             
 ; 

 ; Ŀ
 ;   Dek - increment all numbers in all strings in selected stuff.         
 ; 
 (DEFUN C:DEK ()
  (inkal dekk "increment")
 (princ))

 ; Ŀ
 ;   Ink- decrement all numbers in all strings in selected stuff.          
 ; 
 (DEFUN C:INK ()
  (inkal ink "decrement")
 (princ))

 ; Ŀ
 ;   Dec.                                                                  
 ; 
 (DEFUN C:DEC ()
  (incab "-" "p" "Entity to initially decrement:")
 (princ))

 ; Ŀ
 ;   Inc.                                                                  
 ; 
 (DEFUN C:INC ()
  (incab "+" "p" "Entity to initially increment:")
 (princ))

 ; Ŀ
 ;   Linc.                                                                 
 ; 
 (DEFUN C:LINC ()
  (incab "+" "s" "Entity to end increment:")
 (princ))

 ; Ŀ
 ;   Ldec.                                                                 
 ; 
 (DEFUN C:LDEC ()
  (incab "-" "s" "Entity to end decrement:")
 (princ))

(princ)